package com.vf106.tools.activity.base;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.alibaba.fastjson.JSONObject;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.vf106.tools.listener.OnHttpFailListener;
import com.vf106.tools.listener.OnHttpSuccessListener;
import com.vf106.tools.utils.HttpUtil;

import java.util.Map;

public abstract class HttpBaseActivity extends BaseActivity {
    protected RequestQueue requestQueue;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (requestQueue == null) {
            requestQueue = Volley.newRequestQueue(getApplicationContext());
        }
        super.onCreate(savedInstanceState);
    }


    public void processResponse(String response, String url, String successMsg, String failMessage, OnHttpSuccessListener listener, OnHttpFailListener failListener) {
        try {
            processResponse(JSONObject.parseObject(response), url, successMsg, failMessage, listener, failListener);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processResponse(String response, String url, String successMsg, String failMessage, OnHttpSuccessListener listener) {
        processResponse(response, url, successMsg, failMessage, listener, null);
    }

    public void processResponse(JSONObject response, String url, String successMsg, String failMessage, OnHttpSuccessListener listener) {
        HttpUtil.processResponse(this, response, url, successMsg, failMessage, listener, null);
    }

    public void processResponse(JSONObject response, String url, String successMsg, String failMessage, OnHttpSuccessListener listener, OnHttpFailListener failListener) {
        HttpUtil.processResponse(this, response, url, successMsg, failMessage, listener, failListener);
    }

    public void processError(VolleyError error, String url, String errorMsg) {
        HttpUtil.processError(this, error, url, errorMsg);
    }

    public void getData(int requestMethod, String url, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Map<String, String> headers) {
        if (!isNetworkConnected(this)) {
            toast("Please check the network.");
            return;
        }
        HttpUtil.getData(requestQueue, requestMethod, url, listener, errorListener, headers);
    }

    public void postData(int requestMethod, String url, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Object params, final Map<String, String> headers) {
        if (!isNetworkConnected(this)) {
            toast("Please check the network.");
            return;
        }
        HttpUtil.postData(requestQueue, requestMethod, url, listener, errorListener, params, headers);
    }

    protected void postFormData(int requestMethod, String url, Response.Listener<String> listener, Response.ErrorListener errorListener, final Map<String, String> params, final Map<String, String> headers) {
        if (!isNetworkConnected(this)) {
            toast("Please check the network.");
            return;
        }
        HttpUtil.postFormData(requestQueue, requestMethod, url, listener, errorListener, params, headers);
    }
}
